<?php

use App\Enums\Role;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\BookingController;
use App\Http\Controllers\DepartmentController;
use App\Http\Controllers\DesignationController;
use App\Http\Controllers\DiagnosisFormController;
use App\Http\Controllers\DoctorController;
use App\Http\Controllers\DoctorScheduleController;
use App\Http\Controllers\DoctorSlotController;
use App\Http\Controllers\DoctorWorkingHourController;
use App\Http\Controllers\FavouriteDoctorController;
use App\Http\Controllers\PatientController;
use App\Http\Controllers\PlanController;
use App\Http\Controllers\SlotController;
use App\Http\Controllers\SpecializationController;
use App\Http\Controllers\SpecializationServiceController;
use App\Http\Controllers\VideoConsultationController;
use App\Http\Middleware\AuthorizeMiddleware;
use Illuminate\Support\Facades\Route;

Route::prefix('v1')->group(function () {

  //AUTH ROUTES

  Route::prefix('auth')->group(function () {
    Route::post('register', [AuthController::class, 'register']);
    Route::post('login', [AuthController::class, 'login']);
    Route::post('logout', [AuthController::class, 'logout'])->middleware(AuthorizeMiddleware::class . ':' . implode(',', [Role::ADMIN->value, Role::DOCTOR->value, Role::USER->value]));
    Route::post('password-reset/request', [AuthController::class, 'passwordResetRequest']);
    Route::post('password-reset/otp', [AuthController::class, 'passwordResetOtpRequest']);
    Route::post('password-reset/confirm', [AuthController::class, 'passwordResetConfirm']);
    Route::middleware('auth:api')->post('refresh-token', [AuthController::class, 'refresh']);
  });
  Route::get('profile', [AuthController::class, 'profile'])
    ->middleware(AuthorizeMiddleware::class . ':' . implode(',', [Role::ADMIN->value, Role::DOCTOR->value, Role::USER->value]));

  // Video consultation routes
  Route::get('consultations/{bookingId}', [VideoConsultationController::class, 'getMeetingCredentials'])
    ->middleware(AuthorizeMiddleware::class . ':' . implode(',', [Role::DOCTOR->value, Role::USER->value]));
  Route::get('consultations/{bookingId}/doctor-meeting', [VideoConsultationController::class, 'getDoctorMeetingDetails'])
    ->middleware(AuthorizeMiddleware::class . ':' . Role::DOCTOR->value);
  Route::get('consultations/{bookingId}/patient-meeting', [VideoConsultationController::class, 'getPatientMeetingDetails'])
    ->middleware(AuthorizeMiddleware::class . ':' . Role::USER->value);
  Route::get('consultations/status/{participantId}', [VideoConsultationController::class, 'checkJoinStatus'])
    ->middleware(AuthorizeMiddleware::class . ':' . implode(',', [Role::DOCTOR->value, Role::USER->value]));

  //DIAGNOSIS FORM
  Route::get('diagnosis', [DiagnosisFormController::class, 'index'])->middleware(AuthorizeMiddleware::class . ':' . Role::DOCTOR->value);
  Route::post('diagnosis', [DiagnosisFormController::class, 'store'])->middleware(AuthorizeMiddleware::class . ':' . Role::ADMIN->value);
  Route::get('diagnosis/{designationId}', [DiagnosisFormController::class, 'show'])->middleware(AuthorizeMiddleware::class . ':' . Role::ADMIN->value);
  Route::patch('diagnosis/{designationId}', [DiagnosisFormController::class, 'update'])->middleware(AuthorizeMiddleware::class . ':' . Role::ADMIN->value);
  //REVIEW ROUTES
  Route::post('reviews/{bookingId}', [DoctorController::class, 'submitReview'])->middleware(AuthorizeMiddleware::class . ':' . Role::USER->value);
  Route::post('reviews/{reviewId}/like', [DoctorController::class, 'likeReview'])->middleware(AuthorizeMiddleware::class . ':' . Role::USER->value);


  //DEPARTMENT ROUTES

  Route::get('departments/list', [DepartmentController::class, 'publicIndex']);
  Route::apiResource('departments', DepartmentController::class)
    ->middleware(AuthorizeMiddleware::class . ':' . Role::ADMIN->value);

  //DESIGNATION ROUTES

  Route::get('designations/list', [DesignationController::class, 'publicIndex']);
  Route::apiResource('designations', DesignationController::class)
    ->middleware(AuthorizeMiddleware::class . ':' . Role::ADMIN->value);

  //SPECIALIZATION ROUTES

  Route::get('specializations/list', [SpecializationController::class, 'publicIndex']);
  Route::apiResource('specializations', SpecializationController::class)
    ->middleware(AuthorizeMiddleware::class . ':' . Role::ADMIN->value);

  // Specialization Services
  Route::get('specializations/{id}/services/list', [SpecializationServiceController::class, 'publicIndex']);
  Route::apiResource('specializations/{specializationId}/services', SpecializationServiceController::class)
    ->middleware(AuthorizeMiddleware::class . ':' . Role::ADMIN->value);

  //PLAN ROUTES

  Route::apiResource('plans', PlanController::class)
    ->middleware(AuthorizeMiddleware::class . ':' . Role::ADMIN->value);
  Route::patch('plans/{id}/action', [PlanController::class, 'action'])
    ->middleware(AuthorizeMiddleware::class . ':' . Role::ADMIN->value);

  // Doctor Working Hours
  Route::apiResource('doctors/working-hours', DoctorWorkingHourController::class);
  // Doctor Working Days
  Route::prefix('doctors/working-days')->group(function () {
    Route::post('/', [DoctorController::class, 'createSlot'])
      ->middleware(AuthorizeMiddleware::class . ':' . implode(',', [Role::ADMIN->value, Role::DOCTOR->value]));
    Route::get('/', [DoctorController::class, 'getworkingDays'])
      ->middleware(AuthorizeMiddleware::class . ':' . implode(',', [Role::ADMIN->value, Role::DOCTOR->value]));;
    Route::delete('{id}', [DoctorController::class, 'deleteWorkingDay'])
      ->middleware(AuthorizeMiddleware::class . ':' . implode(',', [Role::ADMIN->value, Role::DOCTOR->value]));
  });

  // DOCTOR ROUTES
  Route::post('favourite-doctor/{id}', [FavouriteDoctorController::class, 'addFavorite'])->middleware(AuthorizeMiddleware::class . ':' . implode(',', [Role::USER->value]));
  Route::get('favourite-doctors', [FavouriteDoctorController::class, 'getFavorites'])->middleware(AuthorizeMiddleware::class . ':' . implode(',', [Role::USER->value]));
  Route::delete('favourite-doctor/{id}', [FavouriteDoctorController::class, 'removeFavorite'])->middleware(AuthorizeMiddleware::class . ':' . implode(',', [Role::USER->value]));

  Route::get('doctors', [DoctorController::class, 'index'])
    ->middleware(AuthorizeMiddleware::class . ':' . implode(',', [Role::ADMIN->value, Role::USER->value]));
  Route::get('doctors/{id}/details', [DoctorController::class, 'showDetails'])
    ->middleware(AuthorizeMiddleware::class . ':' . implode(',', [Role::USER->value]));
  Route::get('doctors/{id}', [DoctorController::class, 'show'])
    ->middleware(AuthorizeMiddleware::class . ':' . implode(',', [Role::ADMIN->value]));
  Route::patch('doctors/{id}', [DoctorController::class, 'update'])
    ->middleware(AuthorizeMiddleware::class . ':' . Role::ADMIN->value);

  Route::patch('doctors/{id}/action', [DoctorController::class, 'action'])
    ->middleware(AuthorizeMiddleware::class . ':' . Role::ADMIN->value);

  // Doctor Slots
  Route::apiResource('doctors/{doctorId}/slots', SlotController::class);
  Route::get('doctors/{doctorId}/reviews', [DoctorController::class, 'getDoctorReviews'])
    ->middleware(AuthorizeMiddleware::class . ':' . implode(',', [Role::ADMIN->value, Role::DOCTOR->value, Role::USER->value]));

  // PATIENT ROUTES
  Route::get('patients', [PatientController::class, 'index'])
    ->middleware(AuthorizeMiddleware::class . ':' . implode(',', [Role::ADMIN->value, Role::USER->value]));
  Route::get('patients/{id}', [PatientController::class, 'show'])
    ->middleware(AuthorizeMiddleware::class . ':' . implode(',', [Role::ADMIN->value, Role::USER->value]));
  Route::patch('patients/{id}', [PatientController::class, 'update'])
    ->middleware(AuthorizeMiddleware::class . ':' . Role::ADMIN->value);
  Route::delete('patients/{id}', [PatientController::class, 'destroy'])
    ->middleware(AuthorizeMiddleware::class . ':' . Role::ADMIN->value);

  Route::patch('patients/{id}/action', [PatientController::class, 'action'])->middleware(AuthorizeMiddleware::class . ':' . Role::ADMIN->value);

  //BOOKING APPOINTMENT ROUTES
  Route::post('appointments/vist/{bookingId}', [BookingController::class, 'doctorReports'])
    ->middleware(AuthorizeMiddleware::class . ':' . implode(',', [Role::DOCTOR->value]));
  Route::get('appointments/vist/{bookingId}', [BookingController::class, 'getPrevDoctorReports'])
    ->middleware(AuthorizeMiddleware::class . ':' . implode(',', [Role::DOCTOR->value, Role::USER->value]));

  Route::get('appointments', [BookingController::class, 'index'])
    ->middleware(AuthorizeMiddleware::class . ':' . implode(',', [Role::ADMIN->value, Role::DOCTOR->value, Role::USER->value]));

  Route::get('appointments/{id}', [BookingController::class, 'show'])
    ->middleware(AuthorizeMiddleware::class . ':' . implode(',', [Role::ADMIN->value, Role::DOCTOR->value, Role::USER->value]));

  Route::post('appointments/slot/{slotId}', [BookingController::class, 'store'])
    ->middleware(AuthorizeMiddleware::class . ':' . Role::USER->value);

  Route::patch('appointments/{id}/reschedule', [BookingController::class, 'update'])
    ->middleware(AuthorizeMiddleware::class . ':' . implode(',', [Role::ADMIN->value, Role::DOCTOR->value, Role::USER->value]));

  Route::patch('appointments/{id}/action', [BookingController::class, 'action'])
    ->middleware(AuthorizeMiddleware::class . ':' . implode(',', [Role::ADMIN->value, Role::DOCTOR->value, Role::USER->value]));
});


Route::prefix('v2')->group(function () {

  //Doctor Availabilty Routes

  Route::post('doctors/{doctorId}/availability', [DoctorScheduleController::class, 'store'])->middleware(AuthorizeMiddleware::class . ':' . Role::ADMIN->value);
  Route::get('doctors/{doctorId}/availability', [DoctorScheduleController::class, 'index'])->middleware(AuthorizeMiddleware::class . ':' . Role::ADMIN->value);

  Route::post('doctors/availability', [DoctorScheduleController::class, 'store'])->middleware(AuthorizeMiddleware::class . ':' . Role::DOCTOR->value);
  Route::get('doctors/availability', [DoctorScheduleController::class, 'index'])->middleware(AuthorizeMiddleware::class . ':' . Role::DOCTOR->value);
  Route::delete('doctors/availability/{id}', [DoctorScheduleController::class, 'destroy'])->middleware(AuthorizeMiddleware::class . ':' . implode(',', [Role::ADMIN->value, Role::DOCTOR->value]));

  //Doctor Slot Routes
  Route::post('doctors/{doctorId}/slots', [DoctorSlotController::class, 'store'])->middleware(AuthorizeMiddleware::class . ':' . Role::ADMIN->value);
  Route::get('doctors/{doctorId}/slots', [DoctorSlotController::class, 'index'])->middleware(AuthorizeMiddleware::class . ':' . implode(',', [Role::ADMIN->value, Role::USER->value]));

  Route::post('doctors/slots', [DoctorSlotController::class, 'store'])->middleware(AuthorizeMiddleware::class . ':' . Role::DOCTOR->value);
  Route::get('doctors/slots', [DoctorSlotController::class, 'index'])->middleware(AuthorizeMiddleware::class . ':' . Role::DOCTOR->value);
  Route::delete('doctors/slots/{id}', [DoctorSlotController::class, 'destroy'])->middleware(AuthorizeMiddleware::class . ':' . implode(',', [Role::ADMIN->value, Role::DOCTOR->value]));
});
