<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Account Approved</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #f4f4f4;
        }

        .container {
            width: 100%;
            max-width: 600px;
            margin: auto;
            background: white;
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        td {
            padding: 10px;
            vertical-align: top;
        }

        a {
            color: #1a73e8;
            text-decoration: none;
        }
    </style>
</head>

<body>
    <div class="container">
        <table>
            <tr>
                <td style="width: 50%; border-right: 1px solid #ddd;">
                    <p>Hello {{ $data['loginName'] }},</p>
                    <p>We are pleased to inform you that your account has been approved! You can now access all the
                        features of our platform.</p>
                    <p><a href="{{ $data['homeUrl'] }}/en/login">Login to Your Account</a></p>
                    <p>Thank you for joining us!</p>
                </td>
                <td style="width: 50%; padding-left: 20px; direction: rtl;">
                    <p>مرحبا {{ $data['loginName'] }},</p>
                    <p>يسعدنا إبلاغك بأن حسابك قد تمت الموافقة عليه! يمكنك الآن الوصول إلى جميع ميزات منصتنا.</p>
                    <p><a href="{{ $data['homeUrl'] }}/ar/login">تسجيل الدخول إلى حسابك</a></p>
                    <p>شكرًا لانضمامك إلينا!</p>
                </td>
            </tr>
        </table>
    </div>
</body>

</html>
