<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Password Reset</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #f4f4f4;
        }

        .container {
            width: 100%;
            max-width: 600px;
            margin: auto;
            background: white;
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        td {
            padding: 10px;
            vertical-align: top;
        }

        a {
            color: #1a73e8;
            text-decoration: none;
        }
    </style>
</head>

<body>
    <div class="container">
        <table>
            <tr>
                <td style="width: 50%; border-right: 1px solid #ddd;">
                    <p>Hello {{ $data['loginName'] }},</p>
                    <p>We received a request to reset your password. Use the OTP below to proceed with resetting your
                        password:</p>
                    <p><strong>OTP: {{ $data['otp'] }}</strong></p>
                    <p>This OTP is valid for a limited time. If you did not request a password reset, please ignore this
                        email.</p>
                    <p>Thank you!</p>
                </td>
                <td style="width: 50%; padding-left: 20px; direction: rtl;">
                    <p>مرحبًا {{ $data['loginName'] }},</p>
                    <p>لقد تلقينا طلبًا لإعادة تعيين كلمة المرور الخاصة بك. استخدم رمز التحقق (OTP) أدناه للمتابعة:</p>
                    <p><strong>رمز التحقق: {{ $data['otp'] }}</strong></p>
                    <p>هذا الرمز صالح لفترة محدودة. إذا لم تطلب إعادة تعيين كلمة المرور، يرجى تجاهل هذا البريد
                        الإلكتروني.</p>
                    <p>شكرًا لك!</p>

                </td>
            </tr>
        </table>
    </div>
</body>

</html>
