<?php

namespace Database\Seeders;

use Carbon\Carbon;
use DB;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SubscriptionStatusSeeder extends Seeder
{
  /**
   * Run the database seeds.
   */
  public function run(): void
  {
    DB::table('subscription_status')->insert([
      ['id' => 1, 'name' => 'Active', 'description' => 'Subscription is currently active and valid.', 'created_at' => Carbon::now('UTC'), 'updated_at' => Carbon::now('UTC')],
      ['id' => 2, 'name' => 'Expired', 'description' => 'Subscription has expired and needs renewal.', 'created_at' => Carbon::now('UTC'), 'updated_at' => Carbon::now('UTC')],
      ['id' => 3, 'name' => 'Pending', 'description' => 'Subscription is awaiting approval or payment.', 'created_at' => Carbon::now('UTC'), 'updated_at' => Carbon::now('UTC')],
      ['id' => 4, 'name' => 'Suspended', 'description' => 'Subscription has been temporarily suspended.', 'created_at' => Carbon::now('UTC'), 'updated_at' => Carbon::now('UTC')],
    ]);
  }
}
