<?php

namespace Database\Seeders;

use Carbon\Carbon;
use DB;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SpecializationSeeder extends Seeder
{
  /**
   * Run the database seeds.
   */
  public function run(): void
  {
    DB::table('specialization')->insert([
      [
        'id' => 1,
        'name' => 'Neurology',
        'description' => 'Specialization dealing with the diagnosis and treatment of disorders affecting the nervous system.',
        'name_ar' => 'علم الأعصاب',
        'description_ar' => 'تخصص يهتم بتشخيص وعلاج الاضطرابات التي تؤثر على الجهاز العصبي.',
        'created_at' => Carbon::now('UTC'),
        'updated_at' => Carbon::now('UTC')
      ],
      [
        'id' => 2,
        'name' => 'Cardiology',
        'description' => 'Specialization focused on diagnosing and treating heart and blood vessel-related conditions.',
        'name_ar' => 'أمراض القلب',
        'description_ar' => 'تخصص يركز على تشخيص وعلاج أمراض القلب والأوعية الدموية.',
        'created_at' => Carbon::now('UTC'),
        'updated_at' => Carbon::now('UTC')
      ],
      [
        'id' => 3,
        'name' => 'Dermatology',
        'description' => 'Specialization concerned with the diagnosis and treatment of skin, hair, and nail disorders.',
        'name_ar' => 'الأمراض الجلدية',
        'description_ar' => 'تخصص يهتم بتشخيص وعلاج أمراض الجلد والشعر والأظافر.',
        'created_at' => Carbon::now('UTC'),
        'updated_at' => Carbon::now('UTC')
      ],
    ]);

    DB::table('specialization_service')->insert([
      // **Neurology Services**
      [
        'id' => 1,
        'specialization_id' => 1,
        'name' => 'Diagnosis and treatment of neurological disorders',
        'description' => 'Services for diagnosing and managing diseases of the brain, spinal cord, and nerves.',
        'name_ar' => 'تشخيص وعلاج الاضطرابات العصبية',
        'description_ar' => 'خدمات لتشخيص وإدارة أمراض الدماغ والحبل الشوكي والأعصاب.',
        'created_at' => Carbon::now('UTC'),
        'updated_at' => Carbon::now('UTC')
      ],
      [
        'id' => 2,
        'specialization_id' => 1,
        'name' => 'Stroke rehabilitation',
        'description' => 'Therapeutic programs to help patients recover from strokes and regain lost abilities.',
        'name_ar' => 'إعادة تأهيل السكتة الدماغية',
        'description_ar' => 'برامج علاجية لمساعدة المرضى على التعافي من السكتات الدماغية واستعادة القدرات المفقودة.',
        'created_at' => Carbon::now('UTC'),
        'updated_at' => Carbon::now('UTC')
      ],
      [
        'id' => 3,
        'specialization_id' => 1,
        'name' => 'Epilepsy management',
        'description' => 'Specialized care and treatment for individuals living with epilepsy.',
        'name_ar' => 'إدارة مرض الصرع',
        'description_ar' => 'رعاية وعلاج متخصص للأشخاص الذين يعانون من مرض الصرع.',
        'created_at' => Carbon::now('UTC'),
        'updated_at' => Carbon::now('UTC')
      ],
      [
        'id' => 4,
        'specialization_id' => 1,
        'name' => 'Memory and cognitive assessments',
        'description' => 'Evaluations to assess memory function and cognitive abilities.',
        'name_ar' => 'تقييمات الذاكرة والإدراك',
        'description_ar' => 'تقييمات لقياس وظائف الذاكرة والقدرات الإدراكية.',
        'created_at' => Carbon::now('UTC'),
        'updated_at' => Carbon::now('UTC')
      ],

      // **Cardiology Services**
      [
        'id' => 5,
        'specialization_id' => 2,
        'name' => 'Heart disease diagnosis and management',
        'description' => 'Comprehensive care for diagnosing and managing various heart conditions.',
        'name_ar' => 'تشخيص وإدارة أمراض القلب',
        'description_ar' => 'رعاية شاملة لتشخيص وإدارة حالات القلب المختلفة.',
        'created_at' => Carbon::now('UTC'),
        'updated_at' => Carbon::now('UTC')
      ],
      [
        'id' => 6,
        'specialization_id' => 2,
        'name' => 'ECG and stress tests',
        'description' => 'Diagnostic tests to evaluate heart function and detect abnormalities.',
        'name_ar' => 'اختبارات تخطيط القلب والجهد',
        'description_ar' => 'اختبارات تشخيصية لتقييم وظائف القلب واكتشاف أي تشوهات.',
        'created_at' => Carbon::now('UTC'),
        'updated_at' => Carbon::now('UTC')
      ],
      [
        'id' => 7,
        'specialization_id' => 2,
        'name' => 'Hypertension treatment',
        'description' => 'Management of high blood pressure through medication and lifestyle changes.',
        'name_ar' => 'علاج ارتفاع ضغط الدم',
        'description_ar' => 'إدارة ارتفاع ضغط الدم من خلال الأدوية وتغيير نمط الحياة.',
        'created_at' => Carbon::now('UTC'),
        'updated_at' => Carbon::now('UTC')
      ],
      [
        'id' => 8,
        'specialization_id' => 2,
        'name' => 'Cardiac rehabilitation',
        'description' => 'Recovery programs for patients with heart conditions to improve cardiovascular health.',
        'name_ar' => 'إعادة تأهيل القلب',
        'description_ar' => 'برامج تعافي لمرضى القلب لتحسين صحة القلب والأوعية الدموية.',
        'created_at' => Carbon::now('UTC'),
        'updated_at' => Carbon::now('UTC')
      ],

      // **Dermatology Services**
      [
        'id' => 9,
        'specialization_id' => 3,
        'name' => 'Skin cancer screening',
        'description' => 'Early detection and diagnosis of skin cancer through comprehensive examinations.',
        'name_ar' => 'فحص سرطان الجلد',
        'description_ar' => 'الكشف المبكر عن سرطان الجلد من خلال الفحوصات الشاملة.',
        'created_at' => Carbon::now('UTC'),
        'updated_at' => Carbon::now('UTC')
      ],
      [
        'id' => 10,
        'specialization_id' => 3,
        'name' => 'Acne and eczema treatment',
        'description' => 'Treatment plans for managing acne, eczema, and other skin conditions.',
        'name_ar' => 'علاج حب الشباب والأكزيما',
        'description_ar' => 'خطط علاجية لإدارة حب الشباب والأكزيما وغيرها من الحالات الجلدية.',
        'created_at' => Carbon::now('UTC'),
        'updated_at' => Carbon::now('UTC')
      ],
      [
        'id' => 11,
        'specialization_id' => 3,
        'name' => 'Cosmetic procedures',
        'description' => 'Non-surgical treatments such as Botox, fillers, and laser therapy for aesthetic improvement.',
        'name_ar' => 'إجراءات تجميلية',
        'description_ar' => 'علاجات غير جراحية مثل البوتوكس والفيلر والعلاج بالليزر لتحسين المظهر.',
        'created_at' => Carbon::now('UTC'),
        'updated_at' => Carbon::now('UTC')
      ],
      [
        'id' => 12,
        'specialization_id' => 3,
        'name' => 'Allergy testing',
        'description' => 'Testing and management of skin-related allergic reactions.',
        'name_ar' => 'اختبار الحساسية',
        'description_ar' => 'اختبارات وإدارة ردود الفعل التحسسية المتعلقة بالجلد.',
        'created_at' => Carbon::now('UTC'),
        'updated_at' => Carbon::now('UTC')
      ],
    ]);
  }
}
