<?php

namespace Database\Seeders;

use Carbon\Carbon;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SlotStatusSeeder extends Seeder
{
  /**
   * Run the database seeds.
   */
  public function run(): void
  {
    DB::table('doctor_availability_status')->insert([
      ['id' => 1, 'name' => 'available', 'description' => 'Doctor is available for appointments.', 'created_at' => Carbon::now('UTC'), 'updated_at' => Carbon::now('UTC')],
      ['id' => 2, 'name' => 'unavailable', 'description' => 'Doctor is not available for appointments.', 'created_at' => Carbon::now('UTC'), 'updated_at' => Carbon::now('UTC')],
      ['id' => 3, 'name' => 'on leave', 'description' => 'Doctor is on leave for the day/Time.', 'created_at' => Carbon::now('UTC'), 'updated_at' => Carbon::now('UTC')],
    ]);

    DB::table('doctor_slot_status')->insert([
      ['id' => 1, 'name' => 'open', 'description' => 'The time slot is open for booking.', 'created_at' => Carbon::now('UTC'), 'updated_at' => Carbon::now('UTC')],
      ['id' => 2, 'name' => 'close', 'description' => 'The time slot is close for booking.', 'created_at' => Carbon::now('UTC'), 'updated_at' => Carbon::now('UTC')],
      ['id' => 3, 'name' => 'booked', 'description' => 'The time slot has been booked.', 'created_at' => Carbon::now('UTC'), 'updated_at' => Carbon::now('UTC')],
      ['id' => 4, 'name' => 'cancelled', 'description' => 'The time slot was canceled.', 'created_at' => Carbon::now('UTC'), 'updated_at' => Carbon::now('UTC')],
    ]);

    DB::table('payment_status')->insert([
      ['id' => 1, 'name' => 'pending', 'description' => 'Payment is pending for the appointment.', 'created_at' => Carbon::now('UTC'), 'updated_at' => Carbon::now('UTC')],
      ['id' => 2, 'name' => 'completed', 'description' => 'Payment has been successfully completed.', 'created_at' => Carbon::now('UTC'), 'updated_at' => Carbon::now('UTC')],
      ['id' => 3, 'name' => 'failed', 'description' => 'Payment attempt failed.', 'created_at' => Carbon::now('UTC'), 'updated_at' => Carbon::now('UTC')],
      ['id' => 4, 'name' => 'refunded', 'description' => 'Payment has been refunded.', 'created_at' => Carbon::now('UTC'), 'updated_at' => Carbon::now('UTC')],
    ]);

    DB::table('booking_status')->insert([
      ['id' => 1, 'name' => 'scheduled', 'description' => 'The appointment is confirmed and scheduled.', 'created_at' => Carbon::now('UTC'), 'updated_at' => Carbon::now('UTC')],
      ['id' => 2, 'name' => 'completed', 'description' => 'The appointment has been successfully completed.', 'created_at' => Carbon::now('UTC'), 'updated_at' => Carbon::now('UTC')],
      ['id' => 3, 'name' => 'cancelled', 'description' => 'The appointment has been canceled by the patient or doctor.', 'created_at' => Carbon::now('UTC'), 'updated_at' => Carbon::now('UTC')],
      ['id' => 4, 'name' => 'no_show', 'description' => 'The patient did not attend the appointment.', 'created_at' => Carbon::now('UTC'), 'updated_at' => Carbon::now('UTC')],
      ['id' => 5, 'name' => 'rescheduled', 'description' => 'The appointment has been rescheduled.', 'created_at' => Carbon::now('UTC'), 'updated_at' => Carbon::now('UTC')],
    ]);
  }
}
