<?php

namespace Database\Seeders;

use Carbon\Carbon;
use DB;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PlanSeeder extends Seeder
{
  /**
   * Run the database seeds.
   */
  public function run(): void
  {
    DB::table('plan')->insert([
      ['id' => 1, 'name' => 'Trial', 'description' => 'A trial plan for doctors to explore the features.', 'price' => 0.00, 'duration_months' => 1, 'currency' => 'USD', 'status' => 1, 'is_trial' => true, 'created_at' => Carbon::now('UTC'), 'updated_at' => Carbon::now('UTC')],
      ['id' => 2, 'name' => 'Basic', 'description' => 'Basic plan with limited features for doctors.', 'price' => 49.99, 'duration_months' => 1, 'currency' => 'USD', 'status' => 1, 'is_trial' => false, 'created_at' => Carbon::now('UTC'), 'updated_at' => Carbon::now('UTC')],
      ['id' => 3, 'name' => 'Premium', 'description' => 'Premium plan with full features for doctors.', 'price' => 149.99, 'duration_months' => 2, 'currency' => 'USD', 'status' => 1, 'is_trial' => false, 'created_at' => Carbon::now('UTC'), 'updated_at' => Carbon::now('UTC')],
    ]);
  }
}
