<?php

namespace Database\Seeders;

use Carbon\Carbon;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class DiagnosisFormSeeder extends Seeder
{
  /**
   * Run the database seeds.
   */
  public function run(): void
  {
    DB::table('diagnosis_form_field')->insert([
      [
        'name' => 'mental_health_severity',
        'label' => 'Mental Health Severity (0-10)',
        'type' => 'slider',
        'options' => json_encode(['min' => 0, 'max' => 10]),
        'is_required' => true,
        'group' => 'Mental Health Severity',
        'order' => 1,
      ],
      [
        'name' => 'severity_note',
        'label' => 'Severity Note',
        'type' => 'textarea',
        'options' => null,
        'is_required' => false,
        'group' => 'Mental Health Severity',
        'order' => 2,
      ],
      [
        'name' => 'mood_level',
        'label' => 'Mood Level (0-10)',
        'type' => 'slider',
        'options' => json_encode(['min' => 0, 'max' => 10]),
        'is_required' => false,
        'group' => 'Mood Tracker',
        'order' => 3,
      ],
      [
        'name' => 'symptoms',
        'label' => 'Symptoms',
        'type' => 'checkbox',
        'options' => json_encode([
          'Insomnia',
          'Appetite Loss',
          'Anxiety',
          'Irritability',
          'Mood Swings',
          'Fatigue',
        ]),
        'is_required' => false,
        'group' => 'Symptoms',
        'order' => 4,
      ],
      [
        'name' => 'memory_impairment',
        'label' => 'Memory Impairment (0-10)',
        'type' => 'slider',
        'options' => json_encode(['min' => 0, 'max' => 10]),
        'is_required' => false,
        'group' => 'Cognitive and Functional Assessments',
        'order' => 5,
      ],
      [
        'name' => 'attention_level',
        'label' => 'Attention Level (0-10)',
        'type' => 'slider',
        'options' => json_encode(['min' => 0, 'max' => 10]),
        'is_required' => false,
        'group' => 'Cognitive and Functional Assessments',
        'order' => 6,
      ],
      [
        'name' => 'social_engagement_level',
        'label' => 'Social Engagement Level (0-10)',
        'type' => 'slider',
        'options' => json_encode(['min' => 0, 'max' => 10]),
        'is_required' => false,
        'group' => 'Cognitive and Functional Assessments',
        'order' => 7,
      ],
      [
        'name' => 'physical_symptoms',
        'label' => 'Physical Symptoms',
        'type' => 'checkbox',
        'options' => json_encode([
          'Muscle tension',
          'Heart palpitations',
          'Shortness of breath',
          'Dizziness',
          'Sweating'
        ]),
        'is_required' => false,
        'group' => 'Physical Symptoms',
        'order' => 8,
      ],
      [
        'name' => 'additional_physical_symptoms',
        'label' => 'Additional Physical Symptoms',
        'type' => 'textarea',
        'options' => null,
        'is_required' => false,
        'group' => 'Physical Symptoms',
        'order' => 9,
      ]
    ]);
  }
}
