<?php

namespace Database\Seeders;

use Carbon\Carbon;
use DB;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DesignationSeeder extends Seeder
{
  /**
   * Run the database seeds.
   */
  public function run(): void
  {
    DB::table('designation')->insert([
      [
        'id' => 1,
        'name' => 'Consultant',
        'description' => 'Highly experienced professionals who offer expert medical advice and treatment.',
        'name_ar' => 'استشاري',
        'description_ar' => 'محترفون ذوو خبرة عالية يقدمون نصائح طبية وعلاجات متخصصة.',
        'created_at' => Carbon::now('UTC'),
        'updated_at' => Carbon::now('UTC')
      ],
      [
        'id' => 2,
        'name' => 'Specialist',
        'description' => 'Medical professionals with expertise in a specific field of medicine.',
        'name_ar' => 'أخصائي',
        'description_ar' => 'محترفون طبيون لديهم خبرة في مجال معين من الطب.',
        'created_at' => Carbon::now('UTC'),
        'updated_at' => Carbon::now('UTC')
      ],
      [
        'id' => 3,
        'name' => 'Resident',
        'description' => 'Doctors in training who are completing their medical education under supervision.',
        'name_ar' => 'مقيم',
        'description_ar' => 'أطباء تحت التدريب يكملون تعليمهم الطبي تحت الإشراف.',
        'created_at' => Carbon::now('UTC'),
        'updated_at' => Carbon::now('UTC')
      ],
      [
        'id' => 4,
        'name' => 'Fellow',
        'description' => 'A specialist in training for a particular medical field beyond residency.',
        'name_ar' => 'زميل',
        'description_ar' => 'أخصائي يخضع لتدريب في مجال طبي معين بعد فترة الإقامة.',
        'created_at' => Carbon::now('UTC'),
        'updated_at' => Carbon::now('UTC')
      ],
      [
        'id' => 5,
        'name' => 'Others',
        'description' => 'Other designations not covered by the above categories.',
        'name_ar' => 'أخرى',
        'description_ar' => 'مسميات وظيفية أخرى غير مشمولة في الفئات المذكورة أعلاه.',
        'created_at' => Carbon::now('UTC'),
        'updated_at' => Carbon::now('UTC')
      ],
    ]);
  }
}
