<?php

namespace Database\Seeders;

use Carbon\Carbon;
use DB;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DepartmentSeeder extends Seeder
{
  /**
   * Run the database seeds.
   */
  public function run(): void
  {
    DB::table('department')->insert([
      [
        'id' => 1,
        'name' => 'Psychiatry',
        'description' => 'Department dealing with the diagnosis and treatment of mental illnesses.',
        'name_ar' => 'الطب النفسي',
        'description_ar' => 'قسم متخصص في تشخيص وعلاج الأمراض النفسية.',
        'created_at' => Carbon::now('UTC'),
        'updated_at' => Carbon::now('UTC')
      ],
      [
        'id' => 2,
        'name' => 'Psychology',
        'description' => 'Department focusing on the study of the human mind and behavior.',
        'name_ar' => 'علم النفس',
        'description_ar' => 'قسم يركز على دراسة العقل البشري والسلوك.',
        'created_at' => Carbon::now('UTC'),
        'updated_at' => Carbon::now('UTC')
      ],
    ]);
  }
}
