<?php

namespace Database\Seeders;

use Carbon\Carbon;
use DB;
use Hash;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class AdminSeeder extends Seeder
{
  /**
   * Run the database seeds.
   */
  public function run(): void
  {
    // Insert into user_account table
    $userId = DB::table('user_account')->insertGetId([
      'first_name' => 'Admin',
      'last_name' => 'Dgitcom',
      'national_id' => '1234567890',
      'national_id_exp_at' => Carbon::now('UTC')->addYears(5),
      'country_code' => '+91',
      'mobile_number' => '9096386842',
      'emergency_country_code' => '+1',
      'emergency_mobile_number' => '1234567890',
      'date_of_birth' => '1990-01-01',
      'gender' => 'male',
      'avatar_url' => 'https://via.placeholder.com/150',
      'role_id' => 1,
      'status' => 1,
      'created_at' => Carbon::now('UTC'),
      'updated_at' => Carbon::now('UTC'),
    ]);

    // Insert into user_login_data table
    DB::table('user_login_data')->insert([
      'user_account_id' => $userId,
      'login_name' => 'admin_user',
      'email' => 'admin@example.com',
      'password_hash' => Hash::make('Admin@123'),
      'reset_token' => null,
      'reset_token_exp_at' => null,
      'created_at' => Carbon::now('UTC'),
      'updated_at' => Carbon::now('UTC'),
    ]);
  }
}
