<?php

namespace Database\Seeders;

use Carbon\Carbon;
use DB;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class AccountStatusSeeder extends Seeder
{
  /**
   * Run the database seeds.
   */
  public function run(): void
  {
    DB::table('account_status')->insert([
      ['id' => 1, 'name' => 'Approved', 'description' => 'User account is approved and can log in', 'created_at' => Carbon::now('UTC'), 'updated_at' => Carbon::now('UTC')],
      ['id' => 2, 'name' => 'Rejected', 'description' => 'User account is rejected and cannot log in', 'created_at' => Carbon::now('UTC'), 'updated_at' => Carbon::now('UTC')],
      ['id' => 3, 'name' => 'Pending', 'description' => 'User account is pending and cannot log in', 'created_at' => Carbon::now('UTC'), 'updated_at' => Carbon::now('UTC')],
      ['id' => 4, 'name' => 'Suspended', 'description' => 'User account is delted and cannot log in', 'created_at' => Carbon::now('UTC'), 'updated_at' => Carbon::now('UTC')],
    ]);
  }
}
