<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('favourite_doctor', function (Blueprint $table) {
      $table->id();
      $table->unsignedBigInteger('patient_id');
      $table->unsignedBigInteger('doctor_id');

      $table->timestamps();

      $table->foreign('patient_id')->references('id')->on('user_account')->onDelete('cascade');
      $table->foreign('doctor_id')->references('id')->on('user_account')->onDelete('cascade');

      $table->unique(['patient_id', 'doctor_id']);
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('favourite_doctor');
  }
};
