<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('review_likes', function (Blueprint $table) {
      $table->id();
      $table->unsignedBigInteger('review_id');
      $table->unsignedBigInteger('patient_id');
      $table->timestamps();

      $table->unique(['review_id', 'patient_id']); // Only one like per user
      $table->foreign('review_id')->references('id')->on('review')->onDelete('cascade');
      $table->foreign('patient_id')->references('id')->on('user_account')->onDelete('cascade');
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('review_likes');
  }
};
