<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('review', function (Blueprint $table) {
      $table->id();
      $table->unsignedBigInteger('booking_id')->unique();
      $table->unsignedBigInteger('doctor_id');
      $table->unsignedBigInteger('patient_id');
      $table->tinyInteger('rating');
      $table->text('review')->nullable();
      $table->timestamps();

      $table->foreign('booking_id')->references('id')->on('patient_booking')->onDelete('cascade');
      $table->foreign('patient_id')->references('id')->on('user_account')->onDelete('cascade');
      $table->foreign('doctor_id')->references('user_account_id')->on('doctor')->onDelete('cascade');
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('review');
  }
};
