<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('video_consultation', function (Blueprint $table) {
      $table->id();
      $table->unsignedBigInteger('booking_id')->unique();
      $table->string('meeting_id');
      $table->string('m_id');
      $table->string('conference_url')->nullable();
      $table->dateTime('scheduled_start');
      $table->dateTime('scheduled_end');
      $table->timestamps();

      $table->foreign('booking_id')->references('id')->on('patient_booking')->onDelete('cascade');
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('video_consultation');
  }
};
