<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('consultation', function (Blueprint $table) {
      $table->id();
      $table->unsignedBigInteger('booking_id');
      $table->date('consultation_date')->nullable();
      $table->time('consultation_time')->nullable();

      $table->text('additional_observations')->nullable();
      $table->text('behavioural_observations')->nullable();
      $table->text('emotional_observations')->nullable();
      $table->text('cognitive_observations')->nullable();

      $table->text('examination')->nullable();
      $table->text('plan')->nullable();
      $table->date('next_appointment_date')->nullable();

      $table->timestamps();

      $table->foreign('booking_id')->references('id')->on('patient_booking')->onDelete('cascade');
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('consultation');
  }
};
