<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('diagnosis_form_value', function (Blueprint $table) {
      $table->id();
      $table->foreignId('submission_id')->constrained('diagnosis_form_submission')->onDelete('cascade');
      $table->foreignId('field_id')->constrained('diagnosis_form_field')->onDelete('cascade');
      $table->json('value')->nullable();
      $table->timestamps();
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('diagnosis_form_value');
  }
};
