<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('diagnosis_form_submission', function (Blueprint $table) {
      $table->id();
      $table->unsignedBigInteger('booking_id');
      $table->timestamp('submitted_at')->nullable();
      $table->timestamps();

      $table->foreign('booking_id')->references('id')->on('patient_booking')->onDelete('cascade');
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('diagnosis_form_submission');
  }
};
