<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('diagnosis_form_field', function (Blueprint $table) {
      $table->id();
      $table->foreignId('designation_id')->nullable()->constrained('designation')->onDelete('cascade'); // NULL = default
      $table->string('name');
      $table->string('label');
      $table->string('type');
      $table->json('options')->nullable(); // For select, checkbox etc.
      $table->boolean('is_required')->default(false);
      $table->string('group')->nullable();
      $table->integer('order')->default(0);
      $table->timestamps();
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('diagnosis_form_field');
  }
};
