<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('patient_prescription', function (Blueprint $table) {
      $table->id();
      $table->unsignedBigInteger('booking_id');
      $table->string('file_url');
      $table->string('original_name');
      $table->string('mime_type');
      $table->integer('size');
      $table->timestamps();

      $table->foreign('booking_id')->references('id')->on('patient_booking')->onDelete('cascade');
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('patient_prescription');
  }
};
