<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('payment', function (Blueprint $table) {
      $table->id();
      $table->unsignedBigInteger('booking_id');
      $table->decimal('amount', 10, 2);
      $table->unsignedBigInteger('status');
      $table->string('method');
      $table->string('transaction_id')->nullable();
      $table->timestamps();

      $table->foreign('booking_id')->references('id')->on('patient_booking')->onDelete('cascade');
      $table->foreign('status')->references('id')->on('payment_status')->onDelete('cascade');
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('payment');
  }
};
