<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('patient_booking', function (Blueprint $table) {
      $table->id();
      $table->unsignedBigInteger('patient_id');
      $table->unsignedBigInteger('doctor_id');
      $table->unsignedBigInteger('slot_id')->unique();
      $table->unsignedBigInteger('status');
      $table->timestamp('booking_date');
      $table->text('visit_reason')->nullable();
      $table->text('symtoms')->nullable();
      $table->text('doctor_notes')->nullable();
      $table->text('reschedule_reason')->nullable();
      $table->timestamp('rescheduled_to')->nullable();
      $table->timestamps();

      $table->foreign('patient_id')->references('id')->on('user_account')->onDelete('cascade');
      $table->foreign('doctor_id')->references('user_account_id')->on('doctor')->onDelete('cascade');
      $table->foreign('slot_id')->references('id')->on('doctor_slot')->onDelete('cascade');
      $table->foreign('status')->references('id')->on('booking_status')->onDelete('cascade');
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('patient_booking');
  }
};
