<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('doctor_slot', function (Blueprint $table) {
      $table->id();
      $table->unsignedBigInteger('doctor_id');
      $table->unsignedBigInteger('working_day_id');
      $table->unsignedBigInteger('working_hour_id');
      $table->foreignId('status')->constrained('doctor_slot_status')->onDelete('cascade');
      $table->timestamps();

      $table->foreign('doctor_id')->references('user_account_id')->on('doctor')->onDelete('cascade');
      $table->foreign('working_day_id')->references('id')->on('doctor_working_day')->onDelete('cascade');
      $table->foreign('working_hour_id')->references('id')->on('doctor_working_hour')->onDelete('cascade');
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('doctor_slot');
  }
};
