<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('doctor_working_hour', function (Blueprint $table) {
      $table->id();
      $table->unsignedBigInteger('doctor_id');
      $table->time('start_time');
      $table->time('end_time');
      $table->foreignId('status')->constrained('doctor_availability_status')->onDelete('cascade');
      $table->timestamps();

      $table->unique(['doctor_id', 'start_time']);
      $table->foreign('doctor_id')->references('user_account_id')->on('doctor')->onDelete('cascade');
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('doctor_working_hour');
  }
};
