<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('subscription', function (Blueprint $table) {
      $table->id();
      $table->foreignId('doctor_id')->constrained('user_account')->onDelete('cascade');
      $table->foreignId('plan_id')->constrained('plan')->onDelete('cascade');
      $table->timestamp('start_date')->default(DB::raw('CURRENT_TIMESTAMP'));
      $table->timestamp('end_date')->default(DB::raw('CURRENT_TIMESTAMP'));
      $table->foreignId('status')->constrained('subscription_status')->onDelete('cascade');
      $table->timestamps();
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('subscription');
  }
};
