<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('plan', function (Blueprint $table) {
          $table->id(); 
          $table->string('name');
          $table->text('description');
          $table->decimal('price', 8, 2); 
          $table->string('currency', 3); 
          $table->integer('duration_months');
          $table->foreignId('status')->constrained('plan_status')->onDelete('cascade');
          $table->boolean('is_trial')->default(false); 
          $table->timestamps(); 
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('plan');
    }
};
