<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('doctor', function (Blueprint $table) {
          $table->unsignedBigInteger('user_account_id');
          $table->string('license_no')->unique();
          $table->foreignId('specialization_id')->constrained('specialization')->onDelete('cascade');
          $table->integer('experience')->default(0)->comment('Years of Experience');
          $table->string('qualification')->nullable();
          $table->string('medical_school')->nullable();
          $table->foreignId('department_id')->constrained('department')->onDelete('cascade');
          $table->foreignId('designation_id')->constrained('designation')->onDelete('cascade');
          $table->text('bio')->nullable();
          $table->text('areas_of_expertise')->nullable();
          $table->text('medical_malpractice');
          $table->foreignId('specialization_service_id')->constrained('specialization_service')->onDelete('cascade');
          $table->integer('avrg_consultation_time')->comment('Time in minutes');
          $table->decimal('avrg_consultation_fee', 10, 2)->comment('Fee in local currency');
          $table->timestamps();

          $table->foreign('user_account_id')->references('id')->on('user_account')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('doctor');
    }
};
