<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('specialization_service', function (Blueprint $table) {
      $table->id();
      $table->foreignId('specialization_id')->constrained('specialization')->onDelete('cascade');
      $table->string('name');
      $table->string('name_ar');
      $table->string('description');
      $table->string('description_ar');
      $table->timestamps();
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('specialization_service');
  }
};
