<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('user_login_data', function (Blueprint $table) {
      $table->id();
      $table->unsignedBigInteger('user_account_id');
      $table->string('login_name')->unique();
      $table->string('email')->unique();
      $table->string('password_hash');
      $table->string('reset_otp')->nullable();
      $table->timestamp('reset_otp_exp_at')->nullable();
      $table->string('reset_token')->nullable();
      $table->timestamp('reset_token_exp_at')->nullable();
      $table->timestamps();

      $table->foreign('user_account_id')->references('id')->on('user_account')->onDelete('cascade');
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('user_login_data');
  }
};
