<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
  /**
   * Run the migrations.
   */
  public function up(): void
  {
    Schema::create('user_account', function (Blueprint $table) {
      $table->id();
      $table->string('first_name');
      $table->string('last_name');
      $table->string('national_id')->unique();
      $table->date('national_id_exp_at');
      $table->string('country_code');
      $table->string('mobile_number')->unique();
      $table->string('emergency_country_code')->nullable();
      $table->string('emergency_mobile_number')->nullable();
      $table->date('date_of_birth');
      $table->enum('gender', ['male', 'female', 'other']);
      $table->string('avatar_url');
      $table->foreignId('role_id')->constrained('role')->onDelete('cascade');
      $table->foreignId('status')->constrained('account_status')->onDelete('cascade');
      $table->text('reject_note')->nullable();
      $table->text('deleted_note')->nullable();
      $table->timestamps();
    });
  }

  /**
   * Reverse the migrations.
   */
  public function down(): void
  {
    Schema::dropIfExists('user_account');
  }
};
