<?php

namespace App\Traits;

trait ApiResponse
{
  public function success($message = 'Success', $data = [], $status = 200)
  {
    return response()->json([
      'status' => true,
      'message' => $message,
      'data' => $data
    ], $status);
  }

  public function error($statusCode = 400, $message = 'Something went wrong', $errors = null,)
  {
    $response = [
      'status' => false,
      'message' => $message,
      'statusCode' => $statusCode,

    ];
    if (!empty($errors)) {
      $response['errors'] = $errors;
    }

    return response()->json($response, $statusCode);
  }
}
