<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Facades\Log;

class BMeetService
{
  protected $apiKey;
  protected $apiToken;
  protected $baseUrl;

  public function __construct()
  {
    $this->apiKey = config('services.bmeet.api_key');
    $this->apiToken = config('services.bmeet.api_token');
    $this->baseUrl = config('services.bmeet.base_url', 'https://ijmeet.com/api');
  }
  public function createMeeting($booking)
  {
    try {
      $doctor = $booking->doctor;
      $doctorUser = $doctor->userAccount;
      $patient = $booking->patient;
      $startTime = Carbon::parse($booking->slot->workingHour->start_time);
      $endTime = Carbon::parse($booking->slot->workingHour->end_time);
      $durationMinutes = $startTime->diffInMinutes($endTime);
      $hour = str_pad(floor($durationMinutes / 60), 2, '0', STR_PAD_LEFT);
      $minute = str_pad($durationMinutes % 60, 2, '0', STR_PAD_LEFT);

      Log::info("startTime", [$booking->slot->workingHour->start_time]);
      $response = Http::withHeaders([
        'Apikey' => $this->apiKey,
        'Apitoken' => $this->apiToken,
        'Accept' => 'application/json',
        'Content-Type' => 'application/json',
      ])->post("{$this->baseUrl}/client/create-meeting", [
        'topic' => "Medical Consultation: Dr. {$doctorUser->first_name} - Patient {$patient->first_name} -Time{$startTime}",
        'start_date' => Carbon::parse($booking->slot->workingDay->working_day)->format('Y-m-d'),
        'start_time' => Carbon::parse($booking->slot->workingHour->start_time)->format('h:i A'),
        'timezone' => config('app.timezone'),
        'start_time_zn' => Carbon::parse($booking->booking_date)->format('A'),
        'hour' => $hour,
        'minute' => $minute,
        'enable_waiting_room' => 1
      ]);

      if ($response->successful()) {
        $data = $response->json();
        if ($data['success']) {
          return $data['data'];
        }
      }

      Log::error('BMeet API Error: ', $response->json());
      throw new Exception('Failed to create meeting');
    } catch (Exception $e) {
      Log::error('BMeet Service Error: ' . $e->getMessage());
      throw $e;
    }
  }

  public function getMeetingDetails($meetingId, $userName)
  {
    try {
      $response = Http::get("{$this->baseUrl}/mdetail/{$meetingId}?name={$userName}");
      return $response->json();
    } catch (Exception $e) {
      Log::error('BMeet Service Error: ' . $e->getMessage());
      throw $e;
    }
  }

  public function getModeratorMeetingDetails($meetingId, $userName)
  {
    try {
      $response = Http::withHeaders([
        'Apikey' => $this->apiKey,
        'Apitoken' => $this->apiToken,
        'Accept' => 'application/json',
        'Content-Type' => 'application/json',
      ])->get("{$this->baseUrl}/mdetail/{$meetingId}?name={$userName}");

      return $response->json();
    } catch (Exception $e) {
      Log::error('BMeet Service Error: ' . $e->getMessage());
      throw $e;
    }
  }

  public function getJoinStatus($participantId)
  {
    try {
      $response = Http::get("{$this->baseUrl}/get_status/{$participantId}");
      return $response->json();
    } catch (Exception $e) {
      Log::error('BMeet Service Error: ' . $e->getMessage());
      throw $e;
    }
  }
}
