<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Tymon\JWTAuth\Contracts\JWTSubject;

class UserLoginData extends Authenticatable implements JWTSubject
{
  use Notifiable;
  protected $table = 'user_login_data';
  protected $primaryKey = 'id';
  public $incrementing = true;
  protected $keyType = 'int';

  protected $fillable = [
    'user_account_id',
    'login_name',
    'email',
    'password_hash',
    'reset_otp',
    'reset_otp_exp_at',
    'reset_token',
    'reset_token_exp_at'
  ];
  protected $hidden = [
    'password_hash',
    'reset_otp',
    'reset_otp_exp_at',
    'reset_token',
    'reset_token_exp_at'
  ];

  public function getAuthPassword()
  {
    return $this->password_hash;
  }

  public function userAccount()
  {
    return $this->belongsTo(UserAccount::class, 'user_account_id');
  }
  public function getJWTIdentifier()
  {
    return $this->getKey();
  }

  public function getJWTCustomClaims()
  {
    return [];
  }
  public function doctor()
  {
    return $this->hasMany(Doctor::class, 'user_account_id', 'user_account_id');
  }
}
