<?php

namespace App\Models;

use App\Enums\DoctorSlotStatus;
use Illuminate\Database\Eloquent\Model;

class UserAccount extends Model
{
  protected $table = 'user_account';
  protected $primaryKey = 'id';

  protected $fillable = [
    'first_name',
    'last_name',
    'national_id',
    'national_id_exp_at',
    'country_code',
    'mobile_number',
    'emergency_country_code',
    'emergency_mobile_number',
    'date_of_birth',
    'gender',
    'avatar_url',
    'role_id',
    'status',
    'deleted_note',
    'reject_note'
  ];
  public function loginData()
  {
    return $this->hasOne(UserLoginData::class, 'user_account_id', 'id');
  }
  public function doctor()
  {
    return $this->hasOne(Doctor::class, 'user_account_id', 'id');
  }
  public function department()
  {
    return $this->hasOneThrough(Department::class, Doctor::class, 'user_account_id', 'id', 'id', 'department_id');
  }

  public function specialization()
  {
    return $this->hasOneThrough(Specialization::class, Doctor::class, 'user_account_id', 'id', 'id', 'specialization_id');
  }

  public function nextAvailableSlot()
  {
    return $this->hasOne(DoctorSlot::class, 'doctor_id', 'id')
      ->where('status', DoctorSlotStatus::OPEN->value)
      ->orderBy('created_at', 'asc');
  }
}
