<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Subscription extends Model
{
  protected $table = 'subscription';

  protected $fillable = ['doctor_id', 'plan_id', 'start_date', 'end_date', 'status'];

  public function doctor()
  {
    return $this->belongsTo(UserAccount::class, 'doctor_id', 'id');
  }
  public function plan()
  {
    return $this->belongsTo(Plan::class, 'plan_id', 'id');
  }
}
