<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class SpecializationService extends Model
{
  protected $table = 'specialization_service';

  protected $fillable = [
    'specialization_id',
    'name',
    'description',
    'name_ar',
    'description_ar',
  ];

  /**
   * Relationship with Specialization.
   * A service belongs to a specialization.
   */
  public function specialization()
  {
    return $this->belongsTo(Specialization::class, 'specialization_id');
  }
}
