<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ReviewLike extends Model
{
  protected $table = 'review_likes';

  protected $fillable = [
    'review_id',
    'patient_id',
  ];

  /**
   * Get the review that was liked.
   */
  public function review()
  {
    return $this->belongsTo(DoctorReview::class, 'review_id');
  }

  /**
   * Get the patient (user) who liked the review.
   */
  public function patient()
  {
    return $this->belongsTo(UserAccount::class, 'patient_id');
  }
}
