<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PatientPrescription extends Model
{
  protected $table = 'patient_prescription';

  protected $fillable = [
    'booking_id',
    'file_url',
    'original_name',
    'mime_type',
    'size',
  ];

  protected $casts = [
    'size' => 'integer',
  ];

  public function booking()
  {
    return $this->belongsTo(DoctorBooking::class, 'booking_id');
  }


  public function getFileUrlAttribute()
  {
    return asset('storage/' . $this->file_url);
  }
}
