<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DoctorWorkingHour extends Model
{
  protected $table = 'doctor_working_hour';
  protected $fillable = ['doctor_id', 'start_time', 'end_time', 'status'];

  public function doctor()
  {
    return $this->belongsTo(Doctor::class);
  }

  public function slots()
  {
    return $this->hasMany(DoctorSlot::class, 'working_hour_id');
  }
}
