<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DoctorWorkingDay extends Model
{
  protected $table = 'doctor_working_day';
  protected $fillable = ['doctor_id', 'working_day', 'status'];

  public function doctor()
  {
    return $this->belongsTo(Doctor::class);
  }

  public function slots()
  {
    return $this->hasMany(DoctorSlot::class, 'working_day_id');
  }
}
