<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DoctorSlot extends Model
{
  protected $table = 'doctor_slot';
  protected $fillable = ['doctor_id', 'working_day_id', 'working_hour_id', 'status'];

  public function doctor()
  {
    return $this->belongsTo(Doctor::class);
  }

  public function workingDay()
  {
    return $this->belongsTo(DoctorWorkingDay::class, 'working_day_id');
  }

  public function workingHour()
  {
    return $this->belongsTo(DoctorWorkingHour::class, 'working_hour_id');
  }
}
