<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DoctorReview extends Model
{
  protected $table = 'review';

  protected $fillable = [
    'booking_id',
    'doctor_id',
    'patient_id',
    'rating',
    'review',
  ];

  /**
   * Get the booking associated with the review.
   */
  public function booking()
  {
    return $this->belongsTo(DoctorBooking::class, 'booking_id');
  }

  /**
   * Get the doctor who was reviewed.
   */
  public function doctor()
  {
    return $this->belongsTo(Doctor::class, 'doctor_id', 'user_account_id');
  }

  /**
   * Get the patient who made the review.
   */
  public function patient()
  {
    return $this->belongsTo(UserAccount::class, 'patient_id');
  }

  /**
   * Get the likes for this review.
   */
  public function likes()
  {
    return $this->hasMany(ReviewLike::class, 'review_id');
  }
}
