<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DoctorIdsDocument extends Model
{
  protected $table = 'doctor_ids_document';
  protected $fillable = [
    'doctor_id',
    'original_name',
    'file_url',
    'mime_type',
    'size'
  ];

  public function doctor()
  {
    return $this->belongsTo(Doctor::class, 'doctor_id', 'user_account_id');
  }
}
