<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DoctorCertificate extends Model
{
  protected $table = 'doctor_certificate';
  protected $fillable = [
    'doctor_id',
    'original_name',
    'file_url',
    'mime_type',
    'size'
  ];

  public function doctor()
  {
    return $this->belongsTo(Doctor::class, 'doctor_id', 'user_account_id');
  }
}
