<?php

namespace App\Models;

use App\Enums\BookingStatus;
use Illuminate\Database\Eloquent\Model;

class DoctorBooking extends Model
{
  protected $table = 'patient_booking';
  protected $fillable = [
    'patient_id',
    'doctor_id',
    'slot_id',
    'booking_date',
    'visit_reason',
    'symtoms',
    'doctor_notes',
    'reschedule_reason',
    'rescheduled_to',
    'prescription_url',
    'status',
  ];
  public function patient()
  {
    return $this->belongsTo(UserAccount::class, 'patient_id', 'id');
  }

  // Relationship with Doctor (User)
  public function doctor()
  {
    return $this->belongsTo(Doctor::class, 'doctor_id', 'user_account_id');
  }

  // Relationship with Slot
  public function slot()
  {
    return $this->belongsTo(DoctorSlot::class, 'slot_id', 'id');
  }
  public function prescriptions()
  {
    return $this->hasMany(PatientPrescription::class, 'booking_id');
  }

  public function status()
  {
    return $this->belongsTo(BookingStatus::class, 'status');
  }

  public function videoConsultation()
  {
    return $this->hasOne(VideoConsultation::class, 'booking_id');
  }
}
