<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DoctorAvailability extends Model
{
  protected $table = 'doctor_availability';

  protected $fillable = [
    'doctor_id',
    'start_date',
    'end_date',
    'status',
  ];

  public function doctor()
  {
    return $this->belongsTo(Doctor::class, 'doctor_id', 'user_account_id');
  }
}
