<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Doctor extends Model
{
  protected $table = 'doctor';

  protected $fillable = [
    'user_account_id',
    'license_no',
    'specialization_id',
    'experience',
    'qualification',
    'medical_school',
    'department_id',
    'designation_id',
    'bio',
    'areas_of_expertise',
    'medical_malpractice',
    'specialization_service_id',
    'avrg_consultation_time',
    'avrg_consultation_fee',
  ];

  // Relationships

  public function userAccount()
  {
    return $this->belongsTo(UserAccount::class, 'user_account_id', 'id');
  }
  public function userLoginData()
  {
    return $this->hasOneThrough(
      UserLoginData::class,
      UserAccount::class,
      'id',                 // Foreign key on user_account table
      'user_account_id',    // Foreign key on user_login_data table
      'user_account_id',    // Local key on doctor table
      'id'                  // Local key on user_account table
    )->select(['user_login_data.email']);
  }

  public function department()
  {
    return $this->belongsTo(Department::class, 'department_id');
  }

  public function designation()
  {
    return $this->belongsTo(Designation::class, 'designation_id');
  }

  public function specialization()
  {
    return $this->belongsTo(Specialization::class, 'specialization_id');
  }

  public function specializationService()
  {
    return $this->belongsTo(SpecializationService::class, 'specialization_service_id');
  }

  // Add this relationship for DoctorCertificate
  public function certificates()
  {
    return $this->hasMany(DoctorCertificate::class, 'doctor_id', 'user_account_id');
  }
  public function idsDocumet()
  {
    return $this->hasMany(DoctorIdsDocument::class, 'doctor_id', 'user_account_id');
  }
  public function reviews()
  {
    return $this->hasMany(DoctorReview::class, 'doctor_id', 'user_account_id');
  }

  protected $appends = ['average_rating'];

  public function getAverageRatingAttribute()
  {
    return $this->reviews()->avg('rating') ?? 0;
  }
}
