<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DiagnosisFormValue extends Model
{
  protected $table = 'diagnosis_form_value';
  protected $fillable = [
    'submission_id',
    'field_id',
    'value',
  ];

  public function submission()
  {
    return $this->belongsTo(DiagnosisFormSubmission::class, 'submission_id');
  }

  public function field()
  {
    return $this->belongsTo(DiagnosisFormField::class, 'field_id');
  }
}
