<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DiagnosisFormSubmission extends Model
{
  protected $table = 'diagnosis_form_submission';

  protected $fillable = [
    'booking_id',
    'submitted_at',
  ];

  public function booking()
  {
    return $this->belongsTo(DoctorBooking::class, 'booking_id');
  }

  // public function values()
  // {
  //   return $this->hasMany(DiagnosisFormValue::class, 'submission_id');
  // }
  public function diagnosisValues()
  {
    return $this->hasMany(DiagnosisFormValue::class, 'submission_id', 'id');
  }
}
